(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4044,        138]*)
(*NotebookOutlinePosition[      5253,        176]*)
(*  CellTagsIndexPosition[      5209,        172]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(Apart[\((4  x^4 + 4  x^3 + 16  x^2 + 12  x + 
            8)\)/\((\((x + 1)\)^2 \((x^2 + 1)\)^2)\)]\)], "Input"],

Cell[BoxData[
    \(3\/\((1 + x)\)\^2 + \(2\ \((2 + x)\)\)\/\((1 + x\^2)\)\^2 + 
      1\/\(1 + x\^2\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[
      3\/\((1 + x)\)\^2 + \(2\ \((2 + x)\)\)\/\((1 + x\^2)\)\^2 + 
        1\/\(1 + x\^2\), x]\)], "Input"],

Cell[BoxData[
    \(\(-\(3\/\(1 + x\)\)\) + \(\(-1\) + 2\ x\)\/\(1 + x\^2\) + 
      3\ ArcTan[x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[1/\((Cos[x] + 2)\), x]\)], "Input"],

Cell[BoxData[
    \(\(2\ ArcTan[Tan[x\/2]\/\@3]\)\/\@3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[
      E^\((\(-a\)\ x)\)\ Cos[b\ x], {x, 0, \(+\[Infinity]\)}]\)], "Input"],

Cell[BoxData[
    RowBox[{"If", "[", 
      RowBox[{\(Im[b] == 0 && Re[a] > 0\), ",", \(a\/\(a\^2 + b\^2\)\), ",", 
        RowBox[{
          SubsuperscriptBox["\[Integral]", "0", 
            InterpretationBox["\[Infinity]",
              DirectedInfinity[ 
              1]]], \(\(\[ExponentialE]\^\(\(-a\)\ x\)\ Cos[
                b\ x]\) \[DifferentialD]x\)}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[
      E^\((\(-a\)\ x)\)\ Sin[b\ x], {x, 0, \(+\[Infinity]\)}]\)], "Input"],

Cell[BoxData[
    RowBox[{"If", "[", 
      RowBox[{\(Im[b] == 0 && Re[a] > 0\), ",", \(b\/\(a\^2 + b\^2\)\), ",", 
        RowBox[{
          SubsuperscriptBox["\[Integral]", "0", 
            InterpretationBox["\[Infinity]",
              DirectedInfinity[ 
              1]]], \(\(\[ExponentialE]\^\(\(-a\)\ x\)\ Sin[
                b\ x]\) \[DifferentialD]x\)}]}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\ \)\(Integrate[\((1 - x^2)\)^\((1/2)\) - 1 + x, {x, 0, 
        1}]\)\)\)], "Input"],

Cell[BoxData[
    \(1\/4\ \((\(-2\) + \[Pi])\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(Integrate[
      Pi \((b + \@\(a^2 - y^2\))\)^2 - 
        Pi \((b - \@\(a^2 - y^2\))\)^2, {y, \(-a\), a}]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(2\ a\^2\ b\ \[Pi]\^2\ Sign[a]\)\/\@Sign[a]\^2\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{499, 369},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Inherited, Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"]}},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->True,
"PrintMultipleHorizontalPages"->True}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 132, 2, 50, "Input"],
Cell[1874, 55, 116, 2, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2027, 62, 138, 3, 45, "Input"],
Cell[2168, 67, 111, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2316, 74, 65, 1, 30, "Input"],
Cell[2384, 77, 68, 1, 68, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2489, 83, 105, 2, 30, "Input"],
Cell[2597, 87, 387, 8, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3021, 100, 105, 2, 30, "Input"],
Cell[3129, 104, 387, 8, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3553, 117, 109, 2, 30, "Input"],
Cell[3665, 121, 60, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3762, 127, 153, 3, 54, "Input"],
Cell[3918, 132, 81, 1, 50, "Output"]
}, Open  ]],
Cell[4014, 136, 26, 0, 30, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

